/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemCustomerNotifier;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.PIProblemDataConstants;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.sa.ServiceAgentAttr;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class PIProblemCustomerNotifier
implements ProblemCustomerNotifier,
PIProblemDataConstants,
ServiceAgentAttr {
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private static final String CLASS_NAME = "[PIProblemCustomerNotifier] ";

    public void notifyCustomer(Problem problem) throws HException {
        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] notifyCustomer");
        if (problem instanceof PIProblem) {
            if (ServiceAgentUtils.getEmailSetting()) {
                Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] email enabled");
                PIProblem theProblem = (PIProblem)problem;
                if (theProblem.isNotifyCustomer()) {
                    ServiceAgentAttr.ESAreportingMachInfo rep = ServiceAgentUtils.getReportingMachineInfo(theProblem);
                    boolean RSFSetting = ServiceAgentUtils.ESACheckRSF(rep.machType, rep.machModel, rep.machSerial);
                    if (!RSFSetting || !theProblem.isCallHome() || theProblem.getProblemData().get("pdc_ESA_STATUS") != null) {
                        String calledhome = "N";
                        if (theProblem.isCallHome()) {
                            calledhome = "Y";
                        }
                        String from = "";
                        NetworkInfo networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
                        if (networkInfo != null && networkInfo.getComputerName().length() > 0 && networkInfo.getDomainName().length() > 0) {
                            from = from + networkInfo.getComputerName() + "." + networkInfo.getDomainName();
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] from: " + from);
                        String failingsystem = "";
                        if (theProblem.getReportingRemoteMachineSystem() != null && theProblem.getReportingRemoteMachineSystem().getMOSystemName() != null) {
                            failingsystem = theProblem.getReportingRemoteMachineSystem().getMOSystemName();
                        }
                        if (networkInfo != null && failingsystem.length() == 0) {
                            failingsystem = networkInfo.getComputerName();
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] failingsystem: " + failingsystem);
                        String failingmtms = "";
                        if (theProblem.getFailingSystem().getMTMS() != null) {
                            failingmtms = theProblem.getFailingSystem().getMTMS();
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] failingmtms: " + failingmtms);
                        String refcode = "";
                        if (theProblem.getRefcode() != null) {
                            refcode = theProblem.getRefcode();
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] refcode: " + refcode);
                        String description = "";
                        String[] nlsMessages = theProblem.getNlsMessages();
                        if (nlsMessages != null) {
                            description = nlsMessages[0];
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] description: " + description);
                        String lastOccurred = "";
                        long lastReported = theProblem.getLastReportedTimestamp();
                        if (lastReported > 0L) {
                            SimpleDateFormat df = new SimpleDateFormat();
                            lastOccurred = df.format(new Date(lastReported));
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] lastOccurred: " + lastOccurred);
                        LocalizableText currentStatus = (LocalizableText)theProblem.getProblemData().get("pdc_ESA_STATUS");
                        if (currentStatus == null) {
                            currentStatus = new LocalizableText(" ");
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] currentStatus: " + currentStatus);
                        String pmh = "n/a";
                        if (theProblem.getPMH() != null) {
                            pmh = theProblem.getPMH();
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] pmh: " + pmh);
                        LocalizableText PMRDetails = (LocalizableText)theProblem.getProblemData().get("pdc_ESA_PMRSTATUS");
                        if (PMRDetails == null) {
                            PMRDetails = new LocalizableText(" ");
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] PMRDetails: " + PMRDetails);
                        int rc = ServiceAgentUtils.ESASendEmailMsg(calledhome, new LocalizableText("Problem report from " + from), new LocalizableText("Problem detected on system: " + failingsystem + "\n" + "Machine type-model/serial: " + failingmtms + "\n" + "Problem number: " + String.valueOf(theProblem.getProblemNumber()) + "\n" + "Error: " + refcode + "\n" + "Description: " + description + "\n" + "Last occurred: " + lastOccurred + "\n" + "Current status: " + currentStatus.toString(Locale.US) + "\n" + "PMR number: " + pmh + "\n" + "Details: " + PMRDetails.toString(Locale.US)));
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] customerNotify disabled");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] email disabled");
            }
        } else {
            Trace.trace(TRACE_MASKF, "[PIProblemCustomerNotifier] not a PIProblem");
        }
    }
}

